/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import java.io.IOException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.montoyo.wd.data.RedstoneCtrlData;
import net.montoyo.wd.entity.TileEntityPeripheralBase;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.init.TileInit;
import net.montoyo.wd.utilities.Util;

public class TileEntityRedCtrl
extends TileEntityPeripheralBase {
    private String risingEdgeURL = "";
    private String fallingEdgeURL = "";
    private boolean state = false;

    public TileEntityRedCtrl(BlockPos arg2, BlockState arg3) {
        super((BlockEntityType)TileInit.REDSTONE_CONTROLLER.get(), arg2, arg3);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.risingEdgeURL = tag.m_128461_("RisingEdgeURL");
        this.fallingEdgeURL = tag.m_128461_("FallingEdgeURL");
        this.state = tag.m_128471_("Powered");
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("RisingEdgeURL", this.risingEdgeURL);
        tag.m_128359_("FallingEdgeURL", this.fallingEdgeURL);
        tag.m_128379_("Powered", this.state);
    }

    @Override
    public InteractionResult onRightClick(Player player, InteractionHand hand) {
        if (this.f_58857_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!this.isScreenChunkLoaded()) {
            Util.toast(player, "chunkUnloaded", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        TileEntityScreen tes = this.getConnectedScreen();
        if (tes == null) {
            Util.toast(player, "notLinked", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        TileEntityScreen.Screen scr = tes.getScreen(this.screenSide);
        if ((scr.rightsFor(player) & 1) == 0) {
            Util.toast(player, "restrictions", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        new RedstoneCtrlData(this.f_58857_.m_46472_().m_135782_(), this.m_58899_(), this.risingEdgeURL, this.fallingEdgeURL).sendTo((ServerPlayer)player);
        return InteractionResult.SUCCESS;
    }

    @Override
    public void onNeighborChange(Block neighborType, BlockPos neighborPos) {
        boolean hasPower;
        boolean bl = hasPower = this.f_58857_.m_46753_(this.m_58899_()) || this.f_58857_.m_46753_(this.m_58899_().m_7494_());
        if (hasPower != this.state) {
            this.state = hasPower;
            if (this.state) {
                this.changeURL(this.risingEdgeURL);
            } else {
                this.changeURL(this.fallingEdgeURL);
            }
        }
    }

    public void setURLs(String r, String f) {
        this.risingEdgeURL = r.trim();
        this.fallingEdgeURL = f.trim();
        this.m_6596_();
    }

    private void changeURL(String url) {
        TileEntityScreen tes;
        if (this.f_58857_.f_46443_ || url.isEmpty()) {
            return;
        }
        if (this.isScreenChunkLoaded() && (tes = this.getConnectedScreen()) != null) {
            try {
                tes.setScreenURL(this.screenSide, url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

